# PulseView with FREE-WILi Support

A custom distribution of [PulseView](https://sigrok.org/wiki/PulseView) with integrated FREE-WILi logic analyzer support for Windows and Linux.

## Overview

This repository contains pre-built distributions of PulseView with the FREE-WILi driver integrated into libsigrok. The FREE-WILi is an embedded systems development tool with an integrated FPGA-based logic analyzer. [Learn More](https://freewili.com)

### What's Included

- **Custom libsigrok** with FREE-WILi driver support
- **PulseView GUI** for signal visualization and analysis
- **Protocol decoders** for common interfaces (SPI, I2C, UART, etc.)
- **Platform-specific installers** for easy deployment

## Quick Start

Choose your platform:

- **[Windows Installation →](windows/README.md)** - .exe installers with Zadig driver setup
- **[Linux Installation →](linux/README.md)** - Portable AppImage with udev rules

## Technical Details

### Built From
- **[Sigrok Project](https://github.com/sigrokproject)** - Open source signal analysis suite
- **[FREE-WILi Libsigrok Fork](https://github.com/Ytuf/libsigrok)** - Custom driver implementation

### FREE-WILi Hardware
- **FTDI FT232H-based** logic analyzer (VID:PID 0403:6014)
- **4-channel logic analyzer** with FPGA-configurable protocol monitoring
- **Default protocol**: SPI monitoring

### FPGA Configuration & Pin Mapping
The FREE-WILi's FPGA determines which GPIO pins are monitored in the 4-channel view:

| Configuration | Channel 0 | Channel 1 | Channel 2 | Channel 3 |
|---------------|-----------|-----------|-----------|-----------|
| **SPI** (default) | SPI1_CS_OUT (GPIO13) | SPI1_SCLK_OUT (GPIO14) | SPI1_Tx_OUT (GPIO15) | SPI1_Rx_IN (GPIO12) |
| **UART** | UART1_RTS_OUT (GPIO11) | UART1_CTS_IN (GPIO10) | UART1_Rx_IN (GPIO9) | UART1_Tx_OUT (GPIO8) |
| **I2C** | GPIO_27 | GPIO_26 | I2C_0_SCL (GPIO17) | I2C_0_SDA (GPIO16) |

*Note: The FPGA can be reconfigured from the Main Processor*

### Driver Selection (Important!)
The FREE-WILi device appears under two sigrok drivers:
- **"FREE-WILi (fwili)"** ← **Use this driver** (4 channels)
- **"FTDI LA"** ← Generic FTDI driver (8 channels, is not compatible with FREE-WILi)

**Verification**: When using the correct FREE-WILi driver, you should see exactly **4 channels**. If you see 8 channels, you're using the wrong driver.

## License

This software is released under the **GNU General Public License v3.0**.

- **Free to use, modify, and distribute**
- **Source code available** (see links above)
- **No warranty** - Use at your own risk
- **Copyleft license** - Derivative works must be GPL-compatible

See [LICENSE](LICENSE) for the complete license text.

## Attribution

### Upstream Projects
- **[Sigrok Project](https://sigrok.org/)** - Original signal analysis framework
- **[PulseView](https://sigrok.org/wiki/PulseView)** - GUI application
- **[libsigrok](https://sigrok.org/wiki/Libsigrok)** - Hardware abstraction library

### FREE-WILi Integration
- **Hardware Design**: FREE-WILi development team
- **Driver Implementation**: [Ytuf/libsigrok](https://github.com/Ytuf/libsigrok)
- **Distribution Packaging**: Community contributors

## Support

### General PulseView Support
- **Documentation**: [sigrok.org/wiki](https://sigrok.org/wiki/)
- **Mailing Lists**: [sigrok-devel](https://lists.sourceforge.net/lists/listinfo/sigrok-devel)
- **IRC**: `#sigrok` on [Libera.Chat](https://libera.chat/)

### FREE-WILi Specific Issues
- **Hardware Questions**: Contact your FREE-WILi vendor
- **Driver Issues**: [Ytuf/libsigrok repository](https://github.com/Ytuf/libsigrok)
- **Integration Issues**: This repository's issue tracker

### Platform-Specific Help
- **Windows**: See [windows/README.md](windows/README.md)
- **Linux**: See [linux/README.md](linux/README.md)
---
**Ready to get started?** Choose your platform and follow the installation guide!
