# PulseView FREE-WILi - Linux Installation

Portable AppImage distribution of PulseView with integrated FREE-WILi logic analyzer support for Linux systems.

## System Requirements

- **Linux x86_64** (64-bit) 
- **Ubuntu 22.04+ or equivalent** (built on Ubuntu 22.04 with GLIBC 2.35)
- **sudo access** for one-time USB setup

## Installation

### 1. Set Up USB Device Detection (One-Time Setup)

```bash
chmod +x ./install-udev-rules.sh
./install-udev-rules.sh
```

This script installs USB device rules and checks for driver conflicts. After running, unplug and replug your logic analyzer device.

### 2. Launch PulseView

```bash
chmod +x PulseView-FREE-WILi-1.0.0-x86_64.AppImage
./PulseView-FREE-WILi-1.0.0-x86_64.AppImage
```

## Troubleshooting

### Device Not Detected

**Run USB setup if you haven't:**
```bash
./install-udev-rules.sh
```

**Check device visibility:**
```bash
lsusb # Looking for ID 0403:6014
```

**FTDI driver conflicts:**
```bash
# Temporarily remove conflicting driver (undone on reboot)
sudo modprobe -r ftdi_sio
# Then unplug/replug your device
```

### Wrong Number of Channels

**Problem**: Seeing 8 channels instead of 4

**Solution**: You're using the generic FTDI driver instead of FREE-WILi driver
1. In PulseView, change device driver to "FREE-WILi (fwili)"
2. Restart PulseView if necessary

### Permissions Issues

**Check group membership:**
```bash
groups $USER
```

**Add to plugdev group if needed:**
```bash
sudo usermod -a -G plugdev $USER
# Then log out and back in
```

## Getting Help

### Linux-Specific Issues
- Check device permissions: `ls -la /dev/bus/usb/*/*`
- Review system logs: `dmesg | grep -i ftdi`

### General PulseView Support
- **Documentation**: [sigrok.org/wiki](https://sigrok.org/wiki/)
- **Community**: [sigrok mailing lists](https://lists.sourceforge.net/lists/listinfo/sigrok-devel)

### FREE-WILi Hardware Support
- **FREE-WILi's Website**: [freewili.com](https://freewili.com/)

---

**Installation complete?** Connect your FREE-WILi device and start analyzing signals!

