# PulseView FREE-WILi - Windows Installation

Windows installer packages for PulseView with integrated FREE-WILi logic analyzer support.

## System Requirements

- **Windows 7 or later** (Windows 10/11 recommended)
- **32-bit or 64-bit** architecture supported
- **Administrator access** for driver installation

## Installation

### 1. Download and Install PulseView

Choose the appropriate installer for your system:

- **64-bit Windows**: `pulseview-installer-64.exe` (recommended)
- **32-bit Windows**: `pulseview-installer-32.exe`

**Installation Steps:**
1. Execute the installer
2. Follow the on-screen prompts to complete installation
3. PulseView will be available in the Start menu

### 2. Install USB Driver (Required)

The FREE-WILi device requires a specific USB driver to work with PulseView. To update this driver, we will use Zadig which was installed along with Pulseview.

### What is Zadig?

Zadig is a utility for installing generic USB drivers such as WinUSB, libusb-win32, or libusbK, which are required for PulseView to communicate with many USB logic analyzers.

**Be very careful at this step.** Incorrectly modifying the driver for other devices connected to your computer can cause them to stop working.

**Using Zadig (Included with PulseView):**

1. **Connect your FREE-WILi** device to your computer
2. **Launch Zadig** from the Start menu (installed with PulseView)
3. From the **Options** menu, enable **"List All Devices"**
4. In the dropdown, select **"FreeWili"** device
   > If not visible, ensure your device is connected and try refreshing
5. Select **"WinUSB"** as the target driver
6. Click **"Replace Driver"** (or "Install Driver" if none exists)
7. Wait for installation to complete and close Zadig

⚠️ **Important**: Be careful to select only the FREE-WILi device. Installing the wrong driver on other devices can cause them to malfunction.

## Troubleshooting

### Device Not Detected

**Check USB Connection:**
```
1. Ensure device is properly connected
2. Try a different USB port
3. Check Windows Device Manager for "FreeWili" device
```

**Driver Issues:**
```
1. Re-run Zadig and verify WinUSB driver is installed
2. Try uninstalling and reinstalling the driver
3. Restart Windows after driver changes
```

### Wrong Number of Channels

**Problem**: Seeing 8 channels instead of 4

**Solution**: You're using the generic FTDI driver instead of FREE-WILi driver
1. In PulseView, change device driver to "FREE-WILi (fwili)"
2. Restart PulseView if necessary

### PulseView Won't Start

**Check Installation:**
```
1. Re-run the installer as administrator
2. Try reinstalling PulseView
3. Check Windows Event Viewer for error details
```

**Missing Dependencies:**
```
1. Install Microsoft Visual C++ Redistributable
2. Ensure Windows is up to date
3. Try running in compatibility mode
```

## Getting Help

### Windows-Specific Issues
- Check Windows Device Manager for device conflicts
- Review Windows Event Viewer for error messages
- Ensure antivirus isn't blocking the application

### General PulseView Support
- **Documentation**: [sigrok.org/wiki](https://sigrok.org/wiki/)
- **Community**: [sigrok mailing lists](https://lists.sourceforge.net/lists/listinfo/sigrok-devel)

### FREE-WILi Hardware Support
- **FREE-WILi's Website**: [freewili.com](https://freewili.com/)

---

**Installation complete?** Connect your FREE-WILi device and start analyzing signals!

